package cn.com.duiba.quanyi.center.api.dto.bill;

import cn.com.duiba.quanyi.center.api.enums.bill.BillPushTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 账单表
 * @author mybatis generator 
 * @date 2024-02-26
 */
@Data
public class BillDto implements Serializable {
     
    private static final long serialVersionUID = 17089143496936938L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 账单业务类型 1-江西银商
     * {@link cn.com.duiba.quanyi.center.api.enums.bill.BillBizTypeEnum}
     */
    private Integer bizType;

    /**
     * 推送类型 1 - 增量  2 - 全量
     * @see BillPushTypeEnum
     */
    private Integer pushType;

    /**
     * 周一 ~ 周日 (1 - 7)
     */
    private Integer weekOfTime;

    /**
     * 不同账单业务类型对应不同的业务id 需求id/活动id...
     */
    private Long bizId;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 任务周期 1-每日
     */
    private Integer taskCycle;

    /**
     * 钉钉机器人accessToken
     */
    private String dingTalkToken;

    /**
     * 创建人id
     */
    private Long creatorId;

    /**
     * 创建人姓名
     */
    private String creatorName;

    /**
     * 账单状态 1-正常 2-停用
     */
    private Integer billStatus;

    /**
     * 逻辑删除标志 0-未删除 1-已删除
     */
    private Integer logicDeleted;
}