package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.SeckillActivitySiteCountDetailRecordDto;
import cn.com.duiba.quanyi.center.api.param.activity.SeckillActivitySiteCountDetailRecordSearchParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 秒杀活动场次详情记录表
 * @author kjj mybatis generator 
 * @date 2024-07-10
 */
@AdvancedFeignClient
public interface RemoteSeckillActivitySiteCountDetailRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 秒杀活动场次详情记录集合
     */
    List<SeckillActivitySiteCountDetailRecordDto> selectPage(SeckillActivitySiteCountDetailRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SeckillActivitySiteCountDetailRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 秒杀活动场次详情记录
     */
    SeckillActivitySiteCountDetailRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 秒杀活动场次详情记录
     * @return 执行结果
     */
    int insert(SeckillActivitySiteCountDetailRecordDto dto);

    /**
     * 更新
     * @param dto 秒杀活动场次详情记录
     * @return 影响行数
     */
    int update(SeckillActivitySiteCountDetailRecordDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 获取秒杀库存
     *
     * @param activityId activity id
     * @param startTime  start time
     * @return {@link Map }<{@link Long }, {@link Long }>
     */
    Map<String, String> getSeckillStockByCache(Long activityId, Date startTime);

}