package cn.com.duiba.quanyi.center.api.remoteservice.mall.goods;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.goods.MallGoodsDetailDto;
import cn.com.duiba.quanyi.center.api.param.mall.goods.MallGoodsSaveParam;
import cn.com.duiba.quanyi.center.api.param.mall.goods.MallGoodsUpdateParam;

/**
 * @author xuzhigang
 * @date 2024/5/26 11:31
 **/
@AdvancedFeignClient
public interface RemoteMallGoodsService {

    /**
     * 根据商品库spuId新增商城商品
     * @param goodsAddParam 参数
     * @return 商城spuId
     */
    Long save(MallGoodsSaveParam goodsAddParam);

    /**
     * 更新商城商品
     *
     * @param goodsUpdateParam 更新参数
     * @return 更新结果
     */
    boolean update(MallGoodsUpdateParam goodsUpdateParam) throws BizException;

    /**
     * 根据spuId查询商城商品详情 包含spu和sku信息
     *
     * @param mallSpuId 商品spuId
     * @return 商品详情
     */
    MallGoodsDetailDto detail(Long mallSpuId);

    /**
     * 根据spuId查询商城商品详情 包含spu和sku信息 redis缓存10min
     *
     * @param mallSpuId 商品spuId
     * @return 商品详情
     */
    MallGoodsDetailDto detailWithCache(Long mallSpuId);
}
