/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.login;

import cn.com.duiba.quanyi.center.api.dto.login.LoginBean;
import cn.com.duiba.quanyi.center.api.dto.login.TokenKeyDto;
import cn.com.duiba.quanyi.center.api.remoteservice.login.RemoteTokenKeyService;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TokenUtils
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);
    private ApplicationContext applicationContext;
    private static RemoteTokenKeyService remoteTokenKeyService;
    private static final LoadingCache<Integer, Optional<TokenKeyDto>> cache;
    private static final ObjectMapper objectMapper;

    private TokenUtils() {
    }

    private static <K, V> CacheLoader<K, V> buildCacheLoader(@NonNull Function<K, V> function) {
        return key -> {
            try {
                return function.apply(key);
            }
            catch (Exception e) {
                log.error("key={}", key, (Object)e);
                return null;
            }
        };
    }

    private static Optional<TokenKeyDto> loadTokenKey() {
        TokenKeyDto tokenKey = remoteTokenKeyService.getTokenKey();
        return Optional.ofNullable(tokenKey);
    }

    public static String encodeToken(LoginBean loginBean, String keyEncrypt, int days) {
        if (Objects.isNull(loginBean)) {
            return null;
        }
        Date now = new Date();
        loginBean.setLoginTime(now.getTime());
        loginBean.setDisableTime(DateUtils.addDays((Date)now, (int)days).getTime());
        try {
            TokenKeyDto tokenKey = TokenUtils.getTokenKey();
            if (tokenKey == null) {
                return TokenUtils.encodeToken(loginBean, keyEncrypt);
            }
            String key = TokenUtils.getKey(loginBean.getLoginTime(), tokenKey);
            return loginBean.getLoginTime() + "_" + TokenUtils.encodeToken(loginBean, key);
        }
        catch (JsonProcessingException e) {
            log.warn("[Token], \u52a0\u5bc6token\u9519\u8bef, loginBean={}", (Object)loginBean, (Object)e);
            return null;
        }
    }

    private static String encodeToken(LoginBean loginBean, String key) throws JsonProcessingException {
        return BlowfishUtils.encryptBlowfish((String)objectMapper.writeValueAsString((Object)loginBean), (String)key);
    }

    public static <T extends LoginBean> T decodeToken(String value, String keyEncrypt, Class<T> clazz) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        try {
            TokenKeyDto tokenKey = TokenUtils.getTokenKey();
            if (tokenKey == null) {
                return TokenUtils.doDecodeToken(value, keyEncrypt, clazz);
            }
            Pair<Long, String> pair = TokenUtils.parseValue(value);
            if (pair.getLeft() != null) {
                return TokenUtils.decodeTokenNew(value, pair, tokenKey, clazz);
            }
            if (tokenKey.isAllSwitch()) {
                log.info("[Token], not support old token, value={}", (Object)value);
                return null;
            }
            return TokenUtils.doDecodeToken(value, keyEncrypt, clazz);
        }
        catch (Exception e) {
            log.info("[Token], \u89e3\u5bc6token\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private static <T extends LoginBean> T decodeTokenNew(String value, Pair<Long, String> pair, TokenKeyDto tokenKey, Class<T> clazz) throws JsonProcessingException {
        String key = TokenUtils.getKey((Long)pair.getLeft(), tokenKey);
        T bean = TokenUtils.doDecodeToken(value, key, clazz);
        if (bean == null) {
            return null;
        }
        if (!Objects.equals(pair.getLeft(), ((LoginBean)bean).getLoginTime())) {
            log.info("[Token], token error, value = {}", (Object)value);
            return null;
        }
        if (((LoginBean)bean).getLoginTime() < tokenKey.getTime() && System.currentTimeMillis() > tokenKey.getOldKeyNotAccessibleTime()) {
            log.info("[Token], token not accessible, value = {}", (Object)value);
            return null;
        }
        return bean;
    }

    private static Pair<Long, String> parseValue(String value) {
        int index = value.indexOf("_");
        if (index < 1) {
            return Pair.of(null, (Object)value);
        }
        String timeStr = value.substring(0, index);
        int timeLength = 13;
        if (!NumberUtils.isNumeric((String)timeStr) || timeStr.length() != timeLength) {
            return Pair.of(null, (Object)value);
        }
        return Pair.of((Object)Long.parseLong(timeStr), (Object)value.substring(index + 1));
    }

    private static <T extends LoginBean> T doDecodeToken(String value, String key, Class<T> clazz) throws JsonProcessingException {
        String decodeStr = BlowfishUtils.decryptBlowfish((String)value, (String)key);
        return (T)((LoginBean)objectMapper.readValue(decodeStr, clazz));
    }

    private static String getKey(long time, TokenKeyDto tokenKey) {
        if (time >= tokenKey.getTime()) {
            return tokenKey.getNewKey();
        }
        return tokenKey.getOldKey();
    }

    private static TokenKeyDto getTokenKey() {
        if (remoteTokenKeyService == null) {
            log.error("[Token], remoteTokenKeyService is null");
            return null;
        }
        Optional optional = (Optional)cache.get((Object)1);
        if (Objects.isNull(optional)) {
            log.warn("[Token], Optional is null ");
            return null;
        }
        TokenKeyDto tokenKey = optional.orElse(null);
        if (tokenKey == null) {
            log.warn("[Token], token key not config");
        }
        return tokenKey;
    }

    public void afterPropertiesSet() throws Exception {
        RemoteTokenKeyService tokenKeyService = (RemoteTokenKeyService)this.applicationContext.getBean(RemoteTokenKeyService.class);
        if (tokenKeyService == null) {
            throw new IllegalStateException("there must exists a bean of class RemoteTokenKeyService(in quanyi-center)");
        }
        remoteTokenKeyService = tokenKeyService;
        log.info("[Token], remoteTokenKeyService load");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    static {
        cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).refreshAfterWrite(10L, TimeUnit.SECONDS).maximumSize(100L).build(TokenUtils.buildCacheLoader(key -> TokenUtils.loadTokenKey()));
        objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

