package cn.com.duiba.quanyi.center.api.dto.common;

import cn.com.duiba.quanyi.center.api.enums.pkg.ChannelBizTypeEnum;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 推广链接表
 *
 * @author kjj mybatis generator
 * @date 2023-09-19
 */
@Data
public class SpreadLinkDto implements Serializable {

    private static final long serialVersionUID = -5655035546244746500L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 渠道ID
     */
    private Long channelBizId;

    /**
     * 渠道类型, 1-商品包
     *
     * @see ChannelBizTypeEnum
     */
    private Integer channelBizType;

    /**
     * 小程序appId
     */
    private String mpAppId;

    /**
     * 小程序跳转path
     */
    private String mpPagePath;

    /**
     * 参数短链key
     */
    private String queryShortKey;

    /**
     * 小程序码
     */
    private String mpQrCode;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 对外短链
     */
    private String outUrl;

    /**
     * 多推广方式，统一拼接参数
     */
    private String baseQuery;

    /**
     * 小程序参数（xx=xx&xx=xx&xx=xx格式）
     */
    private String mpQuery;

    /**
     * 小程序h5落地地址，不带域名，可带额外参数
     */
    private String mpH5Path;

    /**
     * 小程序h5背景图
     */
    private String mpH5Img;

    /**
     * 小程序h5推广，落地页地址
     */
    private String mpUrl;

    /**
     * 公众号appId
     */
    private String oaAppId;

    /**
     * 公众号推广，落地页地址，不带域名，带参数
     */
    private String oaUrl;

    /**
     * 普通h5推广，落地页地址，带域名
     */
    private String h5Url;

    /**
     * 小程序h5短链
     */
    private String mpShortUrl;

    /**
     * 公众号h5短链
     */
    private String oaShortUrl;

    /**
     * 普通h5短链
     */
    private String h5ShortUrl;

    public String getMpPath() {
        if (StringUtils.isBlank(queryShortKey)) {
            return mpPagePath;
        }
        return mpPagePath + "?scene=" + queryShortKey;
    }
}