package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.Getter;
import lombok.AllArgsConstructor;

import java.util.Arrays;

/**
 * @author xuzhigang
 * @date 2024/4/29 14:14
 **/
@Getter
@AllArgsConstructor
public enum WxCouponAutoAddMoneyTypeEnum {
    CRON(1, "定时任务触发"),

    REALTIME(2, "库存扣减触发"),

    MANUAL(3, "聚宝盆后台手动触发"),

    UPLOAD(4, "聚宝盆后台批量触发"),
    ;

    private final int type;

    private final String desc;

    public static String getDescByType(Integer addType) {
        return Arrays.stream(values()).filter(t -> t.getType() == addType).findFirst().orElseThrow(() -> new RuntimeException("未找到对应的枚举")).getDesc();
    }
}
