package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动奖品用户配置表
 * @author kjj mybatis generator 
 * @date 2023-11-06
 */
@Data
public class ActivityPrizeUserConfDto implements Serializable {

    private static final long serialVersionUID = -2540643159995361245L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum#getCode()
     */
    private Integer logicDelete;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 活动奖品主键, tb_activity_prize.id
     */
    private Long activityPrizeId;

    /**
     * 用户手机号
     */
    private String userPhone;

    /**
     * 不固定面额批次-发放面额，单位分
     */
    private Long grantAmount;

    /**
     * 总库存
     */
    private Long totalNum;

    /**
     * 已使用数量
     */
    private Long usedNum;

    /**
     * 上传任务id
     */
    private Long taskId;

    /**
     * 添加人类型，1-内部sso用户，2-合作方员工
     * @see cn.com.duiba.quanyi.center.api.enums.activity.OperatorTypeEnum#getType()
     */
    private Integer operatorType;

    /**
     * 添加人Id
     */
    private Long operatorId;

    /**
     * 添加人姓名
     */
    private String operatorName;

    /**
     * 添加时间
     */
    private Date addTime;

    /**
     * 删除人类型，1-内部sso用户，2-合作方员工
     * @see cn.com.duiba.quanyi.center.api.enums.activity.OperatorTypeEnum#getType()
     */
    private Integer deleteOperatorType;

    /**
     * 删除人Id，用于排查问题
     */
    private Long deleteOperatorId;

    /**
     * 删除人姓名，用于排查问题
     */
    private String deleteOperatorName;

    /**
     * 删除时间
     */
    private Date deleteTime;
}