package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate;

import cn.com.duiba.quanyi.center.api.enums.BooleanEnum;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author xuzhigang
 * @date 2024/4/22 17:21
 **/
@Getter
@AllArgsConstructor
public enum WxCouponPaySceneEnum {

    /**
     * 小程序支付
     */
    MINIAPP(1, "小程序支付"),

    /**
     * app支付
     */
    APP(2, "app支付"),

    /**
     * 刷卡支付
     */
    OFFLINE(3, "刷卡"),

    /**
     * 免密支付
     */
    DELEGATE(4, "免密支付"),

    /**
     * 人脸支付
     */
    FACE(5, "人脸支付"),

    /**
     * 刷掌支付
     */
    PALM(6, "刷掌支付"),

    /**
     * 其他支付
     */
    OTHER(7, "其他支付");

    /**
     * 支付场景编码
     */
    private final Integer paySceneCode;
    /**
     * 支付场景描述
     */
    private final String paySceneDesc;

    private static final Map<Integer, WxCouponPaySceneEnum> PAY_SCENE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(WxCouponPaySceneEnum::getPaySceneCode, Function.identity(), (v1, v2) -> v2)));

    public static List<String> convertPaySceneList(List<Integer> paySceneCodeList) {
        if (CollectionUtils.isEmpty(paySceneCodeList)) {
            return Collections.emptyList();
        }
        return paySceneCodeList.stream().map(t -> {
            WxCouponPaySceneEnum sceneEnum = WxCouponPaySceneEnum.getPaySceneEnumByPaySceneCode(t);
            if (sceneEnum == null) {
                return null;
            }
            return sceneEnum.name();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }


    /**
     * 1-小程序支付 2-app支付 7-其他支付转换为收银台定向立减支付方式
     * [0, 1, 1] 0表示不选择 1-表示选择 第一位到第三位分别表示小程序支付、app支付、其他支付
     */
    public static List<Integer> convertDirectCutPaySceneList(List<Integer> paySceneCodeList) {
        List<Integer> directCutPaySceneList = Lists.newArrayList(0, 0, 0);
        if (CollectionUtils.isEmpty(paySceneCodeList)) {
            return directCutPaySceneList;
        }
        paySceneCodeList.forEach(code -> {
            if (MINIAPP.getPaySceneCode().equals(code)) {
                directCutPaySceneList.set(0, BooleanEnum.TRUE.getCode());
            }
            if (APP.getPaySceneCode().equals(code)) {
                directCutPaySceneList.set(1, BooleanEnum.TRUE.getCode());
            }
            if (OTHER.getPaySceneCode().equals(code)) {
                directCutPaySceneList.set(2, BooleanEnum.TRUE.getCode());
            }
        });
        return directCutPaySceneList;
    }

    public static WxCouponPaySceneEnum getPaySceneEnumByPaySceneCode(Integer paySceneCode) {
        return PAY_SCENE_MAP.get(paySceneCode);
    }
}
