package cn.com.duiba.quanyi.center.api.enums.pay;


import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Getter
@AllArgsConstructor
public enum BankCardTypeEnum {
    /**
     *
     */
    CREDIT("credit", "信用卡"),
    DEBIT("debit", "借记卡"),
    CREDIT_DEBIT("debit_and_credit", "信用卡和借记卡"),
    ;

    private final String type;

    private final String desc;


    private static final Map<String, BankCardTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(BankCardTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static BankCardTypeEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

}
