package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityAdminDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityAdminSearchParam;
import java.util.List;

/**
 * 活动管理员表
 * @author kjj mybatis generator 
 * @date 2024-04-22
 */
@AdvancedFeignClient
public interface RemoteActivityAdminService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用（不包含已删除的）
     * @param param 查询条件
     * @return 活动管理员集合
     */
    List<ActivityAdminDto> selectPage(ActivityAdminSearchParam param);

    /**
     * 根据条件,查询记录的总记录数（不包含已删除的）
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityAdminSearchParam param);

    /**
     * 根据主键查询（不包含已删除的）
     * @param id 主键
     * @return 活动管理员
     */
    ActivityAdminDto selectById(Long id);

    /**
     * 根据活动及手机号查询（不包含已删除的）
     *
     * @param activityId 活动id
     * @param adminPhone 管理员手机号
     * @return 活动管理员
     */
    ActivityAdminDto selectByActivityPhone(Long activityId, String adminPhone);

    /**
     * 根据活动及手机号查询（包含已删除的）
     *
     * @param activityId 活动id
     * @param adminPhone 管理员手机号
     * @return 活动管理员
     */
    ActivityAdminDto selectByActivityPhoneContainsLogicDelete(Long activityId, String adminPhone);

    /**
     * 根据活动及用户查询（不包含已删除的）
     *
     * @param activityId 活动id
     * @param userId     用户id
     * @return 活动管理员
     */
    ActivityAdminDto selectByActivityUser(Long activityId, Long userId);

    /**
     * 新增
     * @param dto 活动管理员
     * @return 主键
     */
    Long insert(ActivityAdminDto dto);

    /**
     * 绑定管理员用户
     *
     * @param activityId 活动id
     * @param adminPhone 管理员手机号
     * @param userId     绑定的用户id
     * @return 是否成功
     */
    boolean bindUser(Long activityId, String adminPhone, Long userId);

    /**
     * 软删
     * @param id 主键
     * @param operatorId   操作人id
     * @param operatorName 操作人名字
     * @return 执行结果
     */
    int delete(Long id, Long operatorId, String operatorName);
}