package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.AlipayActivityAutoCreateTaskDto;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayActivityAutoCreateTaskSearchParam;
import java.util.List;

/**
 * 支付宝立减金自动创建批次任务表
 * @author kjj mybatis generator 
 * @date 2024-07-23
 */
@AdvancedFeignClient
public interface RemoteAlipayActivityAutoCreateTaskService {

    /**
     * 根据查询条件分页查询
     * @param param 查询条件
     * @return 支付宝立减金自动创建批次任务
     */
    List<AlipayActivityAutoCreateTaskDto> selectPage(AlipayActivityAutoCreateTaskSearchParam param);

    /**
     * 根据查询条件查询总数
     * @param param 查询条件
     * @return 总数
     */
    Long selectCount(AlipayActivityAutoCreateTaskSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝立减金自动创建批次任务
     */
    AlipayActivityAutoCreateTaskDto selectById(Long id);


    /**
     * 根据上传任务id分页查询
     * @param uploadTaskId 上传任务id
     * @param pageSize 每页数量
     * @param lastId 上次查询id
     * @return 微信立减金自动创建批次任务
     */
    List<AlipayActivityAutoCreateTaskDto> selectByOffset(Long uploadTaskId, int pageSize, Long lastId);
}