package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.DouYinActivityCouponDto;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayActivityBatchUpdateCreatorParam;
import cn.com.duiba.quanyi.center.api.param.coupon.DouYinActivityBatchUpdateCreatorParam;
import cn.com.duiba.quanyi.center.api.param.coupon.DouYinActivityPageParam;
import cn.com.duiba.quanyi.center.api.param.coupon.DouYinActivitySaveOrUpdateParam;
import cn.com.duiba.quanyi.center.api.param.coupon.DouYinBindDemandGoodsParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteDouYinActivityCouponService {


    /**
     * 根据主键查询抖音支付券
     *
     * @param id
     * @return
     */
    DouYinActivityCouponDto selectById(Long id);

    /**
     * 根据抖音活动id查询抖音支付券
     *
     * @param douyinActId 抖音活动id
     * @return
     */
    DouYinActivityCouponDto selectByActId(String douyinActId);

    /**
     * 根据抖音活动id批量查询
     *
     * @param douyinActIds 活动id
     * @return 抖音支付券
     */
    List<DouYinActivityCouponDto> selectByActIds(Set<String> douyinActIds);

    /**
     * 根据id批量查询
     *
     * @param idList
     * @return 抖音支付券 key = 主键，value = 抖音支付券信息
     */
    Map<Long, DouYinActivityCouponDto> selectByIdList(Set<Long> idList);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<DouYinActivityCouponDto> selectPage(DouYinActivityPageParam param);

    /**
     * 查询总数
     *
     * @param param
     * @return
     */
    long selectCount(DouYinActivityPageParam param);

    /**
     * 新增或修改
     *
     * @param param
     * @return
     */
    Long saveOrUpdate(DouYinActivitySaveOrUpdateParam param);

    /**
     * 批量替换创建人
     *
     * @param param 参数
     * @return 影响行数
     */
    int batchUpdateCreator(DouYinActivityBatchUpdateCreatorParam param);

    /**
     * 根据创建人查询创建人数量
     *
     * @param createOperatorId 创建人ID
     * @return 创建人数量
     */
    int selectCreatorCount(Long createOperatorId);


    /**
     * 根据需求商品id和 skuId查询
     *
     * @param demandGoodsId 需求商品 id
     * @param skuId         skuId
     * @return
     */
    List<DouYinActivityCouponDto> selectByDemandGoodsIdSkuId(Long demandGoodsId, Long skuId);

    /**
     * 根据需求id和 skuId查询
     *
     * @param demandId 需求 ID
     * @param skuId    sku ID
     * @return
     */
    List<DouYinActivityCouponDto> selectByDemandSkuId(Long demandId, Long skuId);


    /**
     * 批量绑定需求商品
     *
     * @param list 绑定参数
     * @return 影响行数
     */
    int batchBindDemandGoods(List<DouYinBindDemandGoodsParam> list);

    /**
     * 绑定需求商品
     *
     * @param param 绑定参数
     * @return 影响行数
     */
    int bindDemandGoods(DouYinBindDemandGoodsParam param);

    /**
     * 批量解绑需求商品
     *
     * @param ids           主键
     * @param demandGoodsId 需求商品id
     * @return 影响行数
     */
    int batchUnbindDemandGoods(List<Long> ids, Long demandGoodsId);



    /**
     * 根据需求商品id查询绑定的批次号
     *
     * @param demandGoodsId 需求商品ID
     * @return 抖音支付券列表
     */
    List<DouYinActivityCouponDto> findByDemandGoodsId(Long demandGoodsId);

}
