package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.AlipayActWriteOffStatisticDataDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.AlipayActWriteOffStatisticDataSearchParam;

import java.util.List;

/**
 * 支付宝核销数据统计表
 * @author kjj mybatis generator 
 * @date 2024-08-16
 */
@AdvancedFeignClient
public interface RemoteAlipayActWriteOffStatisticDataService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 支付宝核销数据统计集合
     */
    List<AlipayActWriteOffStatisticDataDto> selectPage(AlipayActWriteOffStatisticDataSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AlipayActWriteOffStatisticDataSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝核销数据统计
     */
    AlipayActWriteOffStatisticDataDto selectById(Long id);

    /**
     * 新增
     * @param dto 支付宝核销数据统计
     * @return 执行结果
     */
    int insert(AlipayActWriteOffStatisticDataDto dto);

    /**
     * 更新
     * @param dto 支付宝核销数据统计
     * @return 影响行数
     */
    int update(AlipayActWriteOffStatisticDataDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}