package cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/6/17 11:15
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CashierDirectCutAutoCreateExtInfoDto extends WxCouponAutoCreateExtInfoDto {

    /**
     * 优惠金额
     */
    private String discountAmount;

    /**
     * 门槛金额（元）
     */
    private String useThreshold;

    /**
     * 活动开始时间
     */
    private String beginTime;

    /**
     * 活动结束时间
     */
    private String endTime;

    /**
     * 有效日期段 1-全部 2-有效期内，规则日期可用 3-有效期内 不规则日期可用
     */
    private Integer periodType;

    /**
     * 星期规则 类型为2时必填 格式：[1,1,1,1,1,1,1] 1-选中 0-不选中
     */
    private List<Integer> weekDay;

    /**
     * 24小时制时段，类型为2|3时必填，格式：00:00-18:00，最长3段
     */
    private List<String> hour24Range;

    /**
     * 日期段，类型为3时必填，格式：2024-04-15&2024-04-17
     */
    private List<String> dateRange;

    /**
     * 定向用户 1-微信标签 2-银行号码包
     */
    private Integer targetUserType;

    /**
     * 时间周期 1-10天内 2-30天内 3-60天内 4-90天内
     */
    private Integer timePeriod;

    /**
     * 用户行为 1-不指定 2-指定银行卡交易笔数区间 3-指定银行卡交易金额区间
     */
    private Integer userBehavior;

    /**
     * 交易笔数区间/交易金额区间 格式1-2
     */
    private List<String> userBehaviorRange;

    /**
     * 绑卡时间 1-不限制 2-指定时间段新绑卡用户
     */
    private Integer bindCardTime;

    /**
     * 号码包id
     */
    private String packageId;

    /**
     * 最高曝光额度
     */
    private String maxExposedAmount;

    /**
     * 参与次数限制
     */
    private Integer userReceiveTimes;

    /**
     * 用户每天优惠次数，参与次数限制大于1时可指定值，不指定代表不限制
     */
    private Integer userDayLimit;

    /**
     * 是否开启自然人拦截(1-开启 2-关闭)
     */
    private Integer useNaturalDefense;

    /**
     * 单天消耗预算，指定时为设置单天预算消耗上限
     */
    private String dayLimitAmount;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行卡类型 1-借记卡 2-信用卡
     */
    private Integer cardType;

    /**
     * 卡bin描述
     */
    private String cardBinDesc;

    /**
     * 卡bin列表
     */
    private List<String> cardBinList;
    /**
     * 支付方式 1-小程序支付 2-app支付 3-其他支付方式
     */
    private List<Integer> payScene;

    private String remark;

}
