package cn.com.duiba.quanyi.center.api.dto.goods;

import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderGrantResult;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单状态变更通知对象
 * 
 * @author lizhi
 * @date 2023/12/22 16:00
 */
@Data
public class GoodsOrderNotifyDto implements Serializable {
    
    private static final long serialVersionUID = -8003271788900483288L;

    /**
     * 商品库订单业务主键
     */
    private Long goodsBizId;

    /**
     * 商品库订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     */
    private Integer goodsBizType;

    /**
     * 业务单号
     */
    private String bizOrderNo;

    /**
     * 订单号
     */
    private String goodsOrderNo;

    /**
     * 规格ID
     */
    private Long skuId;

    /**
     * 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 订单价格，单位分
     */
    private Long orderPrice;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 订单状态, 1-处理中，2-成功，3-失败, 4-异常
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 领取时间
     */
    private Date receiveTime;

    /**
     * 商品库订单号
     */
    private String orderNo;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 展示给前端的错误码
     */
    private String failCode;

    /**
     * 链接券-短链
     */
    private String shortUrl;

    /**
     * 发放方式：1-直充，2-短链
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderGrantTypeEnum
     */
    private Integer grantType;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 活动类型
     *
     * @see BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 关联的需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 发放的批次表主键
     * 如：tb_wx_coupon.id
     *    tb_alipay_activity.id
     */
    private Long couponId;

    /**
     * 发放的面额
     */
    private Long couponAmount;

    /**
     * 调用商品库发放参数
     */
    private String accountInfo;

    /**
     * 发放结果，成功后的状态为空的话，请主动查询实际结果
     */
    private OrderGrantResult grantResult;
}
