package cn.com.duiba.quanyi.center.api.dto.qy.signing;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.signing.SigningStatusEnum;
import lombok.Data;

/**
 * 签约信息表
 * @author mybatis generator 
 * @date 2024-05-09
 */
@Data
public class SigningDto implements Serializable {
     
    private static final long serialVersionUID = 17152576374827363L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 签约类型，0:微信 1:银行卡
     */
    private Integer signingType;

    /**
     * 用户姓名
     */
    private String userName;

    /**
     * 身份证号
     */
    private String userIdentificationCard;

    /**
     * 银行卡号
     */
    private String userBankCard;

    /**
     * 银行卡号 / openId
     */
    private String cardNo;

    /**
     * 手机号
     */
    private String userPhone;

    /**
     * 签约状态 0处理中 1成功 2失败
     * @see SigningStatusEnum
     */
    private Integer signingStatus;

    /**
     * 签约商户主体
     */
    private String mchType;
}