package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.CustomActivityPayRecordDto;
import cn.com.duiba.quanyi.center.api.param.activity.CustomActivityPayRecordSearchParam;
import java.util.List;

/**
 * 定制活动支付记录表
 * @author kjj mybatis generator 
 * @date 2024-07-23
 */
@AdvancedFeignClient
public interface RemoteCustomActivityPayRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 定制活动支付记录集合
     */
    List<CustomActivityPayRecordDto> selectPage(CustomActivityPayRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CustomActivityPayRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 定制活动支付记录
     */
    CustomActivityPayRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 定制活动支付记录
     * @return 执行结果
     */
    Long insert(CustomActivityPayRecordDto dto);

    /**
     * 更新
     * @param dto 定制活动支付记录
     * @return 影响行数
     */
    int update(CustomActivityPayRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}