package cn.com.duiba.quanyi.center.api.remoteservice.mall.page;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.page.MallPageRegionConfDto;
import cn.com.duiba.quanyi.center.api.param.mall.page.MallPageRegionConfSearchParam;
import java.util.List;

/**
 * 商城页面区域配置
 * @author kjj mybatis generator 
 * @date 2024-05-23
 */
@AdvancedFeignClient
public interface RemoteMallPageRegionConfService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商城页面区域配置
     */
    MallPageRegionConfDto selectById(Long id);

    /**
     * 根据主键查询 redis缓存10min
     * @param id 主键
     * @return 商城页面区域配置
     */
    MallPageRegionConfDto selectByIdWithCache(Long id);

    /**
     * 根据关联页面id查询
     * @param linkPageId 关联页面id
     * @return 商城页面区域配置集合
     */
    List<MallPageRegionConfDto> selectByLinkedPageId(Long linkPageId);
}