package cn.com.duiba.quanyi.center.api.remoteservice.statistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.statistic.InsuranceCreditsGrantStatisticDto;
import cn.com.duiba.quanyi.center.api.param.statistic.InsuranceCreditsGrantStatisticSearchParam;
import java.util.List;

/**
 * 保司积分发放统计
 * @author kjj mybatis generator 
 * @date 2024-07-22
 */
@AdvancedFeignClient
public interface RemoteInsuranceCreditsGrantStatisticService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司积分发放统计集合
     */
    List<InsuranceCreditsGrantStatisticDto> selectPage(InsuranceCreditsGrantStatisticSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceCreditsGrantStatisticSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司积分发放统计
     */
    InsuranceCreditsGrantStatisticDto selectById(Long id);

    /**
     * 新增
     * @param dto 保司积分发放统计
     * @return 执行结果
     */
    int insert(InsuranceCreditsGrantStatisticDto dto);

    /**
     * 更新
     * @param dto 保司积分发放统计
     * @return 影响行数
     */
    int update(InsuranceCreditsGrantStatisticDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}