package cn.com.duiba.quanyi.center.api.dto.api.doc;

import lombok.Data;

import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * API文档-结果
 * @author lizhi
 * @date 2023/12/20 15:33
 */
@Data
public class ApiDocDto<T extends Serializable> implements Serializable {
    
    private static final long serialVersionUID = -1721223473760586240L;

    /**
     * 是否请求成功，不代表订单已成功
     */
    private boolean success;

    /**
     * 错误码，成功时为
     */
    private String code;

    /**
     * 错误描述
     */
    private String desc;

    /**
     * 业务数据
     */
    private T bizData;

    public ApiDocDto<T> buildError(String code, String desc) {
        this.success = false;
        this.code = code;
        this.desc = desc;
        return this;
    }

    public ApiDocDto<T> buildSuccess(T bizData) {
        this.success = true;
        this.code = "000000";
        this.bizData = bizData;
        return this;
    }

    public ApiDocDto<T> buildSuccess(Supplier<T> bizDataFunc) {
        return buildSuccess(bizDataFunc.get());
    }
    
}
