/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ApiOrderStatusEnum {
    PROCESS(1, "\u5904\u7406\u4e2d"),
    ISSUED(2, "\u5df2\u53d1\u653e\uff0c\u9488\u5bf9\u5361\u5bc6\u3001\u94fe\u63a5\u5238\u7b49\u5546\u54c1\u6709\u8be5\u72b6\u6001\uff0c\u652f\u6301\u8be5\u72b6\u6001\u7684\u5546\u54c1\u7c7b\u578b"),
    FAIL(3, "\u5931\u8d25\uff0c\u4e00\u822c\u662f\u5916\u90e8\u539f\u56e0\uff0c\u6bd4\u5982\u5145\u503c\u8d26\u53f7\u4e0d\u6b63\u786e"),
    RECEIVED(4, "\u5df2\u5230\u8d26\uff0c\u4e00\u822c\u662f\u76f4\u51b2\u7c7b\u5546\u54c1\uff0c\u5e76\u975e\u6240\u6709\u76f4\u51b2\u5546\u54c1\u90fd\u6709\u8be5\u72b6\u6001"),
    VERIFICATION(5, "\u5df2\u6838\u9500"),
    EXPIRED(6, "\u5df2\u5931\u6548"),
    RED_PACK_RECEIVED(7, "\u5df2\u9886\u53d6"),
    REFUND(8, "\u5df2\u9000\u6b3e"),
    UNSHIPPED(9, "\u5f85\u53d1\u8d27"),
    SHIPPED(10, "\u5f85\u6536\u8d27"),
    COMPLETED(11, "\u5df2\u7b7e\u6536"),
    CANCELED(12, "\u5df2\u53d6\u6d88"),
    RETURNED(13, "\u5df2\u9000\u8d27"),
    CLOSE(14, "\u5df2\u5173\u95ed");

    private final Integer status;
    private final String desc;
    private static final Map<Integer, ApiOrderStatusEnum> ENUM_MAP;

    public static ApiOrderStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return PROCESS;
        }
        return ENUM_MAP.get(status);
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    private ApiOrderStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ApiOrderStatusEnum.values()).collect(Collectors.toMap(ApiOrderStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
    }
}

