package cn.com.duiba.quanyi.center.api.param.bigdata;

import cn.com.duiba.quanyi.center.api.enums.bigdata.BigdataHologresTableEnum;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceTakeGrantParam;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceTakeSplitParam;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2024/3/5 13:55
 */
@Data
public class BigdataHologresDownloadParam implements Serializable {
    
    private static final long serialVersionUID = -6648475263099236277L;

    /**
     * 数据库表名称
     * @see cn.com.duiba.quanyi.center.api.enums.bigdata.BigdataHologresTableEnum
     */
    private String tableName;

    /**
     * 过滤条件
     */
    private List<BigdataQueryConditionParam> filterConditions;

    /**
     * 任务ID
     */
    private String taskId;

    /**
     * 指定文件名称，如果为空则走默认文件名称
     */
    private String fileName;
}
