package cn.com.duiba.quanyi.center.api.dto.insurance.customer;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 保司兑换记录表,日维度汇总数据
 * @author mybatis generator 
 * @date 2024-03-04
 */
@Data
public class InsuranceTakeRecordSumStatisticsDto implements Serializable {
     
    private static final long serialVersionUID = 17095322687184336L;

    /**
     * 日期
     */
    private String curDate;

    /**
     * 业务类型：1-积分转让，2-支付
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceTakeBizTypeEnum
     */
    private Integer takeBizType;

    /**
     * 发放的商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 已领取积分
     */
    private Long takeAmount;
}