package cn.com.duiba.quanyi.center.api.enums.equity.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2024/8/5 16:58
 */
@Getter
@AllArgsConstructor
public enum 
EquityCouponOrderStatusEnum {
    NOT_PAY(1, "待支付"),
    PAY_SUCCESS(2, "已支付"),
    TAKE_SUCCESS(3, "待核销"),
    VERIFICATION(4, "已核销"),
    CLOSE(5, "已取消"),
    INVALID(6, "已作废"),
    REFUNDING(7, "退款中"),
    REFUND_SUCCESS(8, "退款成功"),
    REFUND_FAIL(9, "退款失败"),
    VERIFICATION_EXPIRE(10, "核销过期"),
    ;
    
    private final Integer status;
    
    private final String desc;

    public String logStr() {
        return status + "-" + desc;
    }
}
