package cn.com.duiba.quanyi.center.api.param.car.order;

import cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum;
import cn.com.duiba.quanyi.center.api.param.pay.ext.InsuranceFundCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.pay.ext.WxLiteCreateOrderParam;
import lombok.Data;

import java.io.Serializable;

/**
 * 权益券支付创建订单参数
 * @author lizhi
 * @date 2023/8/7 18:20
 */
@Data
public class EquityCouponPayCreateOrderParam implements Serializable {
    
    private static final long serialVersionUID = 8894539309360592962L;

    /**
     * 门店ID
     */
    private Long storeId;

    /**
     * 服务ID
     */
    private Long storeSerId;

    /**
     * 汽车服务名称
     */
    private String carSerName;

    /**
     * 券ID
     */
    private Long couponId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * appId
     */
    private String appId;

    /**
     * 页面展示需要支付的金额
     */
    private Long pageAmount;

    /**
     * 支付渠道
     * @see PayChannelTypeEnum
     */
    private String payChannelType = PayChannelTypeEnum.WX_LITE.getChannelType();

    /**
     * 微信小程序支付参数
     */
    private WxLiteCreateOrderParam wxLite;

    /**
     * 保司资金账户
     */
    private InsuranceFundCreateOrderParam insuranceFund;
}
