package cn.com.duiba.quanyi.center.api.param.coupon.notify;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2024/3/19 20:55
 **/
@Data
public class AlipayActivityAddMoneyResultNotifyParam implements Serializable {
    private static final long serialVersionUID = -6865501808297257005L;

    /**
     * 商户号
     */
    @NotBlank(message = "商户号不能为空")
    private String mchCode;

    /**
     * 任务id
     */
    @NotNull(message = "任务id不能为空")
    private Long taskId;

    /**
     * 活动id
     */
    @NotNull(message = "活动id不能为空")
    private String activityId;

    /**
     * 加款后金额
     */
    @NotNull(message = "任务金额不能为空")
    private String taskAmount;

    /**
     * true-成功 false-失败
     */
    @NotNull(message = "result不能为空")
    private Boolean result;

    /**
     * 加款失败原因
     */
    private String errorMsg;
}
