/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.alipay;

import cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext.alipay.AlipayActivityAutoCreateExtInfoDto;
import cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext.alipay.CardPayCutAutoCreateExtInfoDto;
import cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.GamePlaySingleTypeEnum;
import cn.com.duiba.quanyi.center.api.utils.StringUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlipayActivityAutoCreateUtils {
    private static final Logger log = LoggerFactory.getLogger(AlipayActivityAutoCreateUtils.class);
    private static final String JOINER = "-";

    public static Long calTotalAmount(Long budgetAmount, Long couponAmount, String startDate, String endDate, Long maxLimitAmount, boolean autoAddMoney) {
        if (!autoAddMoney) {
            return budgetAmount;
        }
        long initAmount = budgetAmount / (long)AlipayActivityAutoCreateUtils.calDiffDays(startDate, endDate).intValue() * 10L;
        initAmount += couponAmount - initAmount % couponAmount;
        if (maxLimitAmount == null) {
            return Math.min(Math.max(initAmount, 5L * couponAmount), budgetAmount);
        }
        return Math.min(Math.max(Math.max(initAmount, 5L * couponAmount), maxLimitAmount), budgetAmount);
    }

    private static Integer calDiffDays(String startDate, String endDate) {
        return DateUtils.daysBetween((Date)DateUtils.getDayDate((String)startDate), (Date)DateUtils.getDayDate((String)endDate)) + 1;
    }

    public static List<AlipayActivityAutoCreateExtInfoDto.Bank> parseBankList(String bankListStr) {
        if (StringUtils.isBlank((CharSequence)bankListStr)) {
            return Collections.emptyList();
        }
        List<String> bankStrList = StringUtil.splitStringWithComma(bankListStr);
        return bankStrList.stream().map(AlipayActivityAutoCreateUtils::parseBank).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static AlipayActivityAutoCreateExtInfoDto.Bank parseBank(String bankStr) {
        List<String> bankNameAndBankCardType = StringUtil.splitStringWithSeparator(bankStr, JOINER);
        if (CollectionUtils.isEmpty(bankNameAndBankCardType)) {
            return null;
        }
        AlipayActivityAutoCreateExtInfoDto.Bank bank = new AlipayActivityAutoCreateExtInfoDto.Bank();
        bank.setName(bankNameAndBankCardType.get(0));
        bank.setCardType(Integer.valueOf(bankNameAndBankCardType.get(1)));
        return bank;
    }

    public static AlipayActivityAutoCreateExtInfoDto.EnableTime parseEnableTime(String weeks, String times) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{weeks, times})) {
            return null;
        }
        AlipayActivityAutoCreateExtInfoDto.EnableTime enableTime = new AlipayActivityAutoCreateExtInfoDto.EnableTime();
        enableTime.setWeeks(StringUtil.splitIntegerWithComma(weeks));
        enableTime.setTimes(StringUtil.splitStringWithComma(times));
        return enableTime;
    }

    public static AlipayActivityAutoCreateExtInfoDto.Alarm parseAlarm(String alarmAmount, String alarmPhone) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{alarmAmount, alarmPhone})) {
            return null;
        }
        AlipayActivityAutoCreateExtInfoDto.Alarm alarm = new AlipayActivityAutoCreateExtInfoDto.Alarm();
        alarm.setAmount(alarmAmount);
        alarm.setPhoneList(StringUtil.splitStringWithComma(alarmPhone));
        return alarm;
    }

    public static CardPayCutAutoCreateExtInfoDto.DayBudget parseDayBudget(Integer dayBudgetType, String dayBudgetAmount) {
        if (dayBudgetType == null || StringUtils.isBlank((CharSequence)dayBudgetAmount)) {
            return null;
        }
        CardPayCutAutoCreateExtInfoDto.DayBudget dayBudget = new CardPayCutAutoCreateExtInfoDto.DayBudget();
        dayBudget.setAmount(dayBudgetAmount);
        dayBudget.setType(dayBudgetType);
        return dayBudget;
    }

    public static CardPayCutAutoCreateExtInfoDto.GamePlaySingle parseGamePlaySingle(Integer gamePlaySingleType, String gamePlaySingleMaxAmount, String gamePlaySingleThreshold, String gamePlaySingleAveragePrice, String gamePlaySingleAverage, String gamePlaySingleRule) {
        if (GamePlaySingleTypeEnum.getByType(gamePlaySingleType) == null) {
            return null;
        }
        CardPayCutAutoCreateExtInfoDto.GamePlaySingle gamePlaySingle = new CardPayCutAutoCreateExtInfoDto.GamePlaySingle();
        gamePlaySingle.setType(gamePlaySingleType);
        gamePlaySingle.setThreshold(gamePlaySingleThreshold);
        if (GamePlaySingleTypeEnum.FIXED_REDUCE.getType().equals(gamePlaySingleType)) {
            gamePlaySingle.setAmount(gamePlaySingleRule);
        }
        if (GamePlaySingleTypeEnum.DISCOUNT_REDUCE.getType().equals(gamePlaySingleType)) {
            gamePlaySingle.setRule(gamePlaySingleRule);
            gamePlaySingle.setMaxAmount(gamePlaySingleMaxAmount);
        }
        if (GamePlaySingleTypeEnum.SMART_REDUCE.getType().equals(gamePlaySingleType)) {
            gamePlaySingle.setAverage(StringUtil.splitStringWithSeparator(gamePlaySingleAverage, JOINER));
            gamePlaySingle.setAveragePrice(gamePlaySingleAveragePrice);
        }
        return gamePlaySingle;
    }

    public static CardPayCutAutoCreateExtInfoDto.GamePlayStep parseGamePlayStep(String gamePlayStepRule, String gamePlayStepMaxAmount) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{gamePlayStepRule, gamePlayStepMaxAmount})) {
            return null;
        }
        CardPayCutAutoCreateExtInfoDto.GamePlayStep gamePlayStep = new CardPayCutAutoCreateExtInfoDto.GamePlayStep();
        gamePlayStep.setMaxAmount(gamePlayStepMaxAmount);
        gamePlayStep.setArray(StringUtil.splitStringWithComma(gamePlayStepRule).stream().map(rule -> {
            List<String> rules = StringUtil.splitStringWithSeparator(rule, JOINER);
            CardPayCutAutoCreateExtInfoDto.GamePlayRule gamePlayRule = new CardPayCutAutoCreateExtInfoDto.GamePlayRule();
            gamePlayRule.setThresholdArea(Lists.newArrayList((Object[])new String[]{rules.get(0), rules.get(1)}));
            gamePlayRule.setType(Integer.parseInt(rules.get(2)));
            gamePlayRule.setRule(rules.get(3));
            return gamePlayRule;
        }).collect(Collectors.toList()));
        return gamePlayStep;
    }

    public static List<CardPayCutAutoCreateExtInfoDto.TimeLimit> parseTimeLimit(String timeLimitStr) {
        if (StringUtils.isBlank((CharSequence)timeLimitStr)) {
            return null;
        }
        List<String> timeLimits = StringUtil.splitStringWithComma(timeLimitStr);
        if (CollectionUtils.isEmpty(timeLimits)) {
            return null;
        }
        return timeLimits.stream().map(timeLimitSingleStr -> {
            CardPayCutAutoCreateExtInfoDto.TimeLimit timeLimit = new CardPayCutAutoCreateExtInfoDto.TimeLimit();
            List<Integer> timeLimitSingle = StringUtil.splitIntegerWithSeparator(timeLimitSingleStr, JOINER);
            timeLimit.setType(timeLimitSingle.get(0));
            timeLimit.setNum(timeLimitSingle.get(1));
            return timeLimit;
        }).collect(Collectors.toList());
    }
}

