package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 抖音支付券批次状态
 */
@Getter
@AllArgsConstructor
public enum DouYinStockStatusEnum {

    INIT("INIT", "待启动"),
    INAP("INAP", "待审批"),
    VALID("VALID", "生效"),
    SUSPEND("SUSPEND", "暂停"),
    INVALID("INVALID", "失效")
    ;
    private final String status;

    private final String desc;

    private static final Map<String, DouYinStockStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(DouYinStockStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static DouYinStockStatusEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
