package cn.com.duiba.quanyi.center.api.remoteservice.ems.js;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ems.js.JsEmsQzMchConfigDto;
import cn.com.duiba.quanyi.center.api.param.ems.js.JsEmsQzMchConfigSearchParam;

import java.util.List;

/**
 * 江苏邮储智慧校园企智商户配置表
 *
 * @author kjj mybatis generator
 * @date 2024-06-13
 */
@AdvancedFeignClient
public interface RemoteJsEmsQzMchConfigService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 江苏邮储智慧校园企智商户配置集合
     */
    List<JsEmsQzMchConfigDto> selectPage(JsEmsQzMchConfigSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(JsEmsQzMchConfigSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 江苏邮储智慧校园企智商户配置
     */
    JsEmsQzMchConfigDto selectById(Long id);

    /**
     * 根据商户号查询来自缓存
     *
     * @param partnerId 商户ID
     * @return 江苏邮储智慧校园企智商户配置
     */
    JsEmsQzMchConfigDto selectByPartnerIdWithLocal(String partnerId);

    /**
     * 新增
     *
     * @param dto 江苏邮储智慧校园企智商户配置
     * @return 执行结果
     */
    int insert(JsEmsQzMchConfigDto dto);

    /**
     * 更新
     *
     * @param dto 江苏邮储智慧校园企智商户配置
     * @return 影响行数
     */
    int update(JsEmsQzMchConfigDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}