/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate;

import cn.com.duiba.quanyi.center.api.enums.BooleanEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public enum WxCouponPaySceneEnum {
    MINIAPP(1, "\u5c0f\u7a0b\u5e8f\u652f\u4ed8"),
    APP(2, "app\u652f\u4ed8"),
    OFFLINE(3, "\u5237\u5361"),
    DELEGATE(4, "\u514d\u5bc6\u652f\u4ed8"),
    FACE(5, "\u4eba\u8138\u652f\u4ed8"),
    PALM(6, "\u5237\u638c\u652f\u4ed8"),
    OTHER(7, "\u5176\u4ed6\u652f\u4ed8");

    private final Integer paySceneCode;
    private final String paySceneDesc;
    private static final Map<Integer, WxCouponPaySceneEnum> PAY_SCENE_MAP;

    public static List<String> convertPaySceneList(List<Integer> paySceneCodeList) {
        if (CollectionUtils.isEmpty(paySceneCodeList)) {
            return Collections.emptyList();
        }
        return paySceneCodeList.stream().map(t -> {
            WxCouponPaySceneEnum sceneEnum = WxCouponPaySceneEnum.getPaySceneEnumByPaySceneCode(t);
            if (sceneEnum == null) {
                return null;
            }
            return sceneEnum.name();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<Integer> convertDirectCutPaySceneList(List<Integer> paySceneCodeList) {
        ArrayList directCutPaySceneList = Lists.newArrayList((Object[])new Integer[]{0, 0, 0});
        if (CollectionUtils.isEmpty(paySceneCodeList)) {
            return directCutPaySceneList;
        }
        paySceneCodeList.forEach(code -> {
            if (MINIAPP.getPaySceneCode().equals(code)) {
                directCutPaySceneList.set(0, BooleanEnum.TRUE.getCode());
            }
            if (APP.getPaySceneCode().equals(code)) {
                directCutPaySceneList.set(1, BooleanEnum.TRUE.getCode());
            }
            if (OTHER.getPaySceneCode().equals(code)) {
                directCutPaySceneList.set(2, BooleanEnum.TRUE.getCode());
            }
        });
        return directCutPaySceneList;
    }

    public static WxCouponPaySceneEnum getPaySceneEnumByPaySceneCode(Integer paySceneCode) {
        return PAY_SCENE_MAP.get(paySceneCode);
    }

    public Integer getPaySceneCode() {
        return this.paySceneCode;
    }

    public String getPaySceneDesc() {
        return this.paySceneDesc;
    }

    private WxCouponPaySceneEnum(Integer paySceneCode, String paySceneDesc) {
        this.paySceneCode = paySceneCode;
        this.paySceneDesc = paySceneDesc;
    }

    static {
        PAY_SCENE_MAP = Collections.unmodifiableMap(Arrays.stream(WxCouponPaySceneEnum.values()).collect(Collectors.toMap(WxCouponPaySceneEnum::getPaySceneCode, Function.identity(), (v1, v2) -> v2)));
    }
}

