package cn.com.duiba.quanyi.center.api.dto.pkg;

import cn.com.duiba.quanyi.center.api.enums.pkg.CodeCouponLinkDimensionEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商品包表
 *
 * @author kjj mybatis generator
 * @date 2023-09-14
 */
@Data
public class GoodsPkgDto implements Serializable {

    private static final long serialVersionUID = -129719524060021059L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 商品包名称
     */
    private String goodsPkgName;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 背景图片
     */
    private String backgroundImg;

    /**
     * 详情描述
     */
    private String detailDesc;

    /**
     * 详情图，多张图用英文逗号分割
     */
    private String detailImgs;

    /**
     * 是否启用, 0-停用, 1-启用
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer goodsPkgStatus;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人名称,ssoname
     */
    private String createOperatorName;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 按钮颜色
     */
    private String buttonColor;

    /**
     * 业务类型：1=权益卡券包、2=兑吧卡密包
     */
    private Integer bizType;

    /**
     * 领取类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.TakeTypeEnum
     */
    private Integer takeType;

    /**
     * 商品类型
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 发放方式：1-直充，2-短链
     *
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderGrantTypeEnum
     */
    private Integer grantType;

    /**
     * logo地址
     */
    private String goodsPkgLogo;

    /**
     * 短链有效天数
     */
    private Integer shortUrlEffectiveDays;

    /**
     * 订阅物流
     */
    private Integer subExpress;

    /**
     * 券码券链接维度
     *
     * @see CodeCouponLinkDimensionEnum
     */
    private Integer codeCouponLinkType;
}