package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeReceiveResultDto;
import cn.com.duiba.quanyi.center.api.dto.activity.SeckillActivityOrderDto;
import cn.com.duiba.quanyi.center.api.param.activity.SeckillActivityOrderSearchParam;
import cn.com.duiba.quanyi.center.api.param.activity.SeckillActivityTakePrizeParam;

import java.util.List;

/**
 * 秒杀活动订单表
 * @author kjj mybatis generator 
 * @date 2024-07-15
 */
@AdvancedFeignClient
public interface RemoteSeckillActivityOrderService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 秒杀活动订单集合
     */
    List<SeckillActivityOrderDto> selectPage(SeckillActivityOrderSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SeckillActivityOrderSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 秒杀活动订单
     */
    SeckillActivityOrderDto selectById(Long id);

    /**
     * 新增
     * @param dto 秒杀活动订单
     * @return 执行结果
     */
    int insert(SeckillActivityOrderDto dto);

    /**
     * 更新
     * @param dto 秒杀活动订单
     * @return 影响行数
     */
    int update(SeckillActivityOrderDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 秒杀领奖
     *
     * @param seckillActivityTakePrizeParam seckill activity take prize param
     * @return 秒杀订单号
     * @throws BizException biz exception
     */
    String takePrize(SeckillActivityTakePrizeParam seckillActivityTakePrizeParam) throws BizException;

    /**
     * 查询领奖结果
     *
     * @param seckillOrderNo 秒杀订单号
     * @return 结果
     */
    ActivityPrizeReceiveResultDto receiveResult(String seckillOrderNo);
}