package cn.com.duiba.quanyi.center.api.remoteservice.insurance.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.customer.InsuranceTakeEquityRecordDto;

import java.util.Date;
import java.util.List;

/**
 * 保司兑换关联权益记录表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceTakeEquityRecordService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司兑换关联权益记录
     */
    InsuranceTakeEquityRecordDto selectById(Long id);


    /**
     * 根据订单号查询
     * @param takeOrderNo 订单号
     * @return 保司兑换关联权益记录
     */
    List<InsuranceTakeEquityRecordDto> selectByTakeOrderNo(String takeOrderNo);


    /**
     * 根据权益ID 查询* 保司兑换关联权益记录表
     * @param insuranceEquityIds ID 结合
     *  Date startTime 开始时间
     *  Date endTime 结束时间
     * @return 结果集
     */
    List<InsuranceTakeEquityRecordDto> selectByInsuranceEquityIdsAndTime(List<Long> insuranceEquityIds, Date startTime, Date endTime);

    /**
     * 根据权益ID 查询保司兑换关联权益记录表
     * @param insuranceEquityIds ID 结合
     * @return 结果集
     */
    List<InsuranceTakeEquityRecordDto> selectByInsuranceEquityIds(List<Long> insuranceEquityIds);
}