package cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext.alipay;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/7/25 15:49
 **/
@Data
public class AlipayActivityAutoCreateExtInfoDto implements Serializable {
    private static final long serialVersionUID = -2379790146595111386L;

    @Data
    public static class Bank {
        /**
         * 银行名称
         */
        private String name;

        /**
         * 银行卡类型 1-借记卡 2-信用卡
         */
        private Integer cardType;
    }

    @Data
    public static class Alarm {
        /**
         * 总预算剩余值进行预警
         */
        private String amount;

        /**
         * 预警接受appId
         */
        private List<String> appidList;

        /**
         * 预警接收手机号（最多填写3个）
         */
        private List<String> phoneList;
    }

    @Data
    public static class EnableTime {
        /**
         * 周日期, 值示例：[1,1,1,0,0,0,1]
         */
        private List<Integer> weeks;

        /**
         * 活动时间, 值示例：['08:00:00,09:00:00', '10:00:00,12:00:00']
         */
        private List<String> times;
    }
}
