package cn.com.duiba.quanyi.center.api.remoteservice.qy.statement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.statement.StatementDemandGoodsDto;
import cn.com.duiba.quanyi.center.api.param.qy.statement.StatementDemandGoodsSearchParam;

import java.util.Date;
import java.util.List;

/**
 * 结算单需求商品表
 *
 * @author kjj mybatis generator
 * @date 2024-07-18
 */
@AdvancedFeignClient
public interface RemoteStatementDemandGoodsService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 结算单需求商品集合
     */
    List<StatementDemandGoodsDto> selectPage(StatementDemandGoodsSearchParam param);

    /**
     * 根据日期查询
     *
     * @param startDate       开始日期
     * @param endDate         结束日期
     * @param searchParamList 查询参数列表
     * @return 结算单中的需求商品
     */
    List<StatementDemandGoodsDto> selectByDemandGoodIdAndStockIdAndDate(Date startDate, Date endDate, List<StatementDemandGoodsSearchParam> searchParamList);

    /**
     * 根据打款明细ID集合查询
     *
     * @param paymentDetailIdList 打款明细ID集合
     * @return 结果
     *
     */
    List<StatementDemandGoodsDto> selectByPaymentDetailIdList(List<Long> paymentDetailIdList);

    /**
     * 根据结算ID列表查询
     *
     * @param statementIdList 结算单ID集合
     * @return 结果
     */
    List<StatementDemandGoodsDto> selectByStatementIdList(List<Long> statementIdList);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(StatementDemandGoodsSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结算单需求商品
     */
    StatementDemandGoodsDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 结算单需求商品
     * @return 执行结果
     */
    int insert(StatementDemandGoodsDto dto);

    /**
     * 批量新增
     *
     * @param dtoList 结算商品列表
     * @return 执行结果
     */
    int batchInsert(List<StatementDemandGoodsDto> dtoList);

    /**
     * 更新
     *
     * @param dto 结算单需求商品
     * @return 影响行数
     */
    int update(StatementDemandGoodsDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}