/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.activity;

import cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum;
import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BatchTakeStatusEnum {
    INIT(1, "\u5f85\u53d1\u653e"),
    PROCESSING(2, "\u53d1\u653e\u4e2d"),
    PART_FAIL(3, "\u90e8\u5206\u53d1\u653e\u5931\u8d25"),
    ALL_FAIL(4, "\u5168\u90e8\u53d1\u653e\u5931\u8d25"),
    ALL_SUCCESS(5, "\u5168\u90e8\u6210\u529f"),
    SHORT_URL_INIT(6, "\u5168\u90e8\u5f85\u9886\u53d6"),
    SHORT_URL_PROCESSING(7, "\u9886\u53d6\u4e2d"),
    SHORT_URL_PART_FAIL(8, "\u90e8\u5206\u9886\u53d6\u5931\u8d25"),
    SHORT_URL_ALL_FAIL(9, "\u5168\u90e8\u9886\u53d6\u5931\u8d25"),
    OBJECT_PART_SUCCESS(10, "\u90e8\u5206\u5b9e\u7269\u72b6\u6001(\u53ef\u91cd\u8bd5)"),
    OBJECT_SUCCESS(11, "\u5168\u90e8\u5b9e\u7269\u72b6\u6001(\u4e0d\u53ef\u91cd\u8bd5)");

    private static final Logger log;
    private final Integer code;
    private final String desc;
    private static final Set<Integer> SHORT_URL_STATUS;

    public static boolean isShortUrlStatus(Integer status) {
        return SHORT_URL_STATUS.contains(status);
    }

    @Nonnull
    public static BatchTakeStatusEnum getByGoodsOrderStatus(List<Integer> goodsOrderStatusList) {
        if (CollectionUtils.isEmpty(goodsOrderStatusList)) {
            return INIT;
        }
        int success = 0;
        int fail = 0;
        int process = 0;
        int notReceive = 0;
        int shortFail = 0;
        int shortProcess = 0;
        for (Integer goodsOrderStatus : goodsOrderStatusList) {
            if (GoodsOrderStatusEnum.PROCESS.getStatus().equals(goodsOrderStatus)) {
                ++process;
                continue;
            }
            if (GoodsOrderStatusEnum.SHORT_URL_RECEIVE_PROCESS.getStatus().equals(goodsOrderStatus)) {
                ++shortProcess;
                continue;
            }
            if (BatchTakeStatusEnum.isFailGoodsOrderStatus(goodsOrderStatus)) {
                ++fail;
                continue;
            }
            if (BatchTakeStatusEnum.isShortFailGoodsOrderStatus(goodsOrderStatus)) {
                ++shortFail;
                continue;
            }
            if (GoodsOrderStatusEnum.NOT_RECEIVE.getStatus().equals(goodsOrderStatus)) {
                ++notReceive;
                continue;
            }
            ++success;
        }
        if (success == goodsOrderStatusList.size()) {
            return ALL_SUCCESS;
        }
        if (fail == goodsOrderStatusList.size()) {
            return ALL_FAIL;
        }
        if (shortFail == goodsOrderStatusList.size()) {
            return SHORT_URL_ALL_FAIL;
        }
        if (notReceive == goodsOrderStatusList.size()) {
            return SHORT_URL_INIT;
        }
        if (fail + shortFail == goodsOrderStatusList.size()) {
            return SHORT_URL_ALL_FAIL;
        }
        if (success + notReceive == goodsOrderStatusList.size()) {
            return SHORT_URL_PROCESSING;
        }
        if (shortProcess > 0) {
            return SHORT_URL_PROCESSING;
        }
        if (shortFail > 0) {
            return SHORT_URL_PART_FAIL;
        }
        if (process > 0) {
            return PROCESSING;
        }
        if (fail > 0) {
            return PART_FAIL;
        }
        log.warn("[BatchTake], status error, goodsOrderStatusList={}", (Object)JSON.toJSONString(goodsOrderStatusList));
        return PROCESSING;
    }

    private static boolean isFailGoodsOrderStatus(Integer goodsOrderStatus) {
        return GoodsOrderStatusEnum.FAIL.getStatus().equals(goodsOrderStatus) || GoodsOrderStatusEnum.EXCEPTION.getStatus().equals(goodsOrderStatus) || GoodsOrderStatusEnum.FAIL_CAN_RETRY.getStatus().equals(goodsOrderStatus);
    }

    private static boolean isShortFailGoodsOrderStatus(Integer goodsOrderStatus) {
        return GoodsOrderStatusEnum.SHORT_URL_RECEIVE_FAIL.getStatus().equals(goodsOrderStatus) || GoodsOrderStatusEnum.SHORT_URL_RECEIVE_FAIL_CAN_RETRY.getStatus().equals(goodsOrderStatus) || GoodsOrderStatusEnum.SHORT_URL_RECEIVE_EXCEPTION.getStatus().equals(goodsOrderStatus);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private BatchTakeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        log = LoggerFactory.getLogger(BatchTakeStatusEnum.class);
        SHORT_URL_STATUS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(SHORT_URL_INIT.getCode(), SHORT_URL_PROCESSING.getCode(), SHORT_URL_PART_FAIL.getCode(), SHORT_URL_ALL_FAIL.getCode())));
    }
}

