package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 针对模板活动的推送 非模板活动勿填
 *
 * @author nongfu
 * @Date 2024/7/3 15:24
 */

@Getter
@AllArgsConstructor
public enum ActivityTempPushEnum {
    COMMON_PUSH(0, "通用活动推送-不推送"),
    HA_ABC_PUSH(1, "湖南长沙农行订单-模板活动推送");


    public static ActivityTempPushEnum getDescByType(Integer type) {
        for (ActivityTempPushEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return COMMON_PUSH;
    }

    private final Integer type;

    private final String desc;
}
