package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.activity.ActivityTemplateWhiteRecordDto;
import cn.com.duiba.quanyi.center.api.param.qy.activity.ActivityTemplateWhiteRecordSearchParam;

import java.util.List;

/**
 * 模板活动白名单导入表
 * @author kjj mybatis generator
 * @date 2024-07-10
 */
@AdvancedFeignClient
public interface RemoteActivityTemplateWhiteRecordService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 模板活动白名单导入集合
     */
    List<ActivityTemplateWhiteRecordDto> selectPage(ActivityTemplateWhiteRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityTemplateWhiteRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 模板活动白名单导入
     */
    ActivityTemplateWhiteRecordDto selectById(Long id);

    /**
     * 根据主键查询
     * @param ids 主键集合
     * @return 模板活动白名单导入
     */
    List<ActivityTemplateWhiteRecordDto> selectByIds(List<Long> ids);

    /**
     * 新增
     * @param dto 模板活动白名单导入
     * @return 执行结果
     */
    int insert(ActivityTemplateWhiteRecordDto dto);

    /**
     * 更新
     * @param dto 模板活动白名单导入
     * @return 影响行数
     */
    int update(ActivityTemplateWhiteRecordDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);


    /**
     * 根据客户号批量去查询
     * @param param 查询条件
     * @return 模板活动白名单导入集合
     */
    List<ActivityTemplateWhiteRecordDto> selectList(ActivityTemplateWhiteRecordSearchParam param);

    /**
     * 批量保存活动白名单用户
     * @param list 数据集合
     * @return 插入结果
     */

    int batchInsert(List<ActivityTemplateWhiteRecordDto> list);


    /**
     * 查询全部数据 上游控制调用量
     * @param param 参数
     * @return 数据集合
     */
    List<ActivityTemplateWhiteRecordDto> selectByCondition(ActivityTemplateWhiteRecordSearchParam param);

    /**
     * id偏移查询 上游控制调用量
     * @param param 参数
     * @return 数据集合
     */
    List<ActivityTemplateWhiteRecordDto> selectByOffset(ActivityTemplateWhiteRecordSearchParam param);

    /**
     * 逻辑删除
     * @param ids
     * @return
     */
    Boolean batchDelete(List<Long> ids);
}