package cn.com.duiba.quanyi.center.api.remoteservice.insurance.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.company.InsuranceCompanyFundChangeRecordDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceCompanyFundChangeRecordSearchParam;
import java.util.List;

/**
 * 保司公司资金变更记录表
 * @author kjj mybatis generator 
 * @date 2024-07-17
 */
@AdvancedFeignClient
public interface RemoteInsuranceCompanyFundChangeRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司公司资金变更记录集合
     */
    List<InsuranceCompanyFundChangeRecordDto> selectPage(InsuranceCompanyFundChangeRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceCompanyFundChangeRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司公司资金变更记录
     */
    InsuranceCompanyFundChangeRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 保司公司资金变更记录
     * @return 执行结果
     */
    int insert(InsuranceCompanyFundChangeRecordDto dto);

    /**
     * 更新
     * @param dto 保司公司资金变更记录
     * @return 影响行数
     */
    int update(InsuranceCompanyFundChangeRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}