package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2024/9/6 15:25
 **/
@Getter
@AllArgsConstructor
public enum SendControlTypeEnum {
    MAIN_APP_ID(1, "仅限活动主体的应用（APPID）进行发放"),
    DIRECT_APP_ID(2, "指定应用（APPID）进行发放"),
    ;

    private final Integer type;
    private final String desc;

    public static SendControlTypeEnum getByType(Integer type) {
        for (SendControlTypeEnum item : SendControlTypeEnum.values()) {
            if (item.type.equals(type)) {
                return item;
            }
        }
        return null;
    }
}
