package cn.com.duiba.quanyi.center.api.param.mall.page;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 商城页面区域配置
 * @author mybatis generator 
 * @date 2024-05-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MallPageRegionConfSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17164469108717718L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Byte logicDelete;

    /**
     * 页面区域Id
     */
    private Long pageRegionId;

    /**
     * 页面ID
     */
    private Long pageId;

    /**
     * 页面区域
     */
    private Byte pageRegion;

    /**
     * 配置图片
     */
    private String confImgs;

    /**
     * 链接类型：1-商品详情页，2-h5链接，3-小程序链接，4-二级页面
     */
    private Byte linkType;

    /**
     * 商城商品Id
     */
    private Long mallSpuId;

    /**
     * 领取类型，1-积分兑换，2-现金支付
     */
    private Byte takeType;

    /**
     * h5链接
     */
    private String h5Link;

    /**
     * 小程序appId
     */
    private String mpAppId;

    /**
     * 小程序跳转path
     */
    private String mpPagePath;

    /**
     * 关联页面ID
     */
    private Long linkPageId;
}