package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.MeiTuanCouponActivityDto;
import cn.com.duiba.quanyi.center.api.param.coupon.MeiTuanCouponActivitySearchParam;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 美团支付券活动关联表
 * @author kjj mybatis generator 
 * @date 2024-09-12
 */
@AdvancedFeignClient
public interface RemoteMeiTuanCouponActivityService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 美团支付券活动关联集合
     */
    List<MeiTuanCouponActivityDto> selectPage(MeiTuanCouponActivitySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MeiTuanCouponActivitySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 美团支付券活动关联
     */
    MeiTuanCouponActivityDto selectById(Long id);

    /**
     * 新增
     * @param dto 美团支付券活动关联
     * @return 执行结果
     */
    int insert(MeiTuanCouponActivityDto dto);

    /**
     * 更新
     * @param dto 美团支付券活动关联
     * @return 影响行数
     */
    int update(MeiTuanCouponActivityDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量查询批次关联活动数量
     * @param couponIds 批次ID列表
     * @return key：批次ID，value：关联活动数量
     */
    Map<Long, Integer> selectActivityCountMapByCouponIds(Set<Long> couponIds);

    /**
     * 根据活动奖品ID和活动类型查询关联活动列表
     * @param activityPrizeId 活动奖品ID
     * @param activityType 活动类型
     * @return 关联活动列表
     */
    List<MeiTuanCouponActivityDto> selectByActivityPrizeIdAndActivityType(Long activityPrizeId, Integer activityType);

    /**
     * 根据活动奖品ID和活动类型查询关联活动列表
     * @param activityPrizeIds 活动奖品ID
     * @param activityType 活动类型
     * @return 关联活动列表
     */
    List<MeiTuanCouponActivityDto> selectByActivityPrizeIds(List<Long> activityPrizeIds, Integer activityType);

    /**
     * 根据券ID查询关联活动列表
     * @param couponIds 券ID列表
     * @return 关联活动列表
     */
    List<MeiTuanCouponActivityDto> selectByMeiTuanCouponIds(Set<Long> couponIds);
}