/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils;

import cn.com.duiba.quanyi.center.api.dto.api.ApiOrderResult;
import cn.com.duiba.quanyi.center.api.dto.api.ApiQuerySubOrderResult;
import cn.com.duiba.quanyi.center.api.dto.api.doc.ApiDocDto;
import cn.com.duiba.quanyi.center.api.dto.api.doc.create.ApiDocOrderCreateDto;
import cn.com.duiba.quanyi.center.api.dto.api.doc.create.ApiDocPkgOrderCreateDto;
import cn.com.duiba.quanyi.center.api.dto.api.doc.create.ApiDocSingleOrderCreateDto;
import cn.com.duiba.quanyi.center.api.dto.api.doc.result.ApiDocOrderResultDto;
import cn.com.duiba.quanyi.center.api.dto.api.doc.result.ApiDocPkgOrderResultDto;
import cn.com.duiba.quanyi.center.api.dto.api.doc.result.async.ApiDocPkgSubAsyncOrderResultDto;
import cn.com.duiba.quanyi.center.api.dto.api.doc.result.async.ApiDocSingleAsyncOrderResultDto;
import cn.com.duiba.quanyi.center.api.dto.api.doc.result.sync.ApiDocPkgSubSyncOrderResultDto;
import cn.com.duiba.quanyi.center.api.dto.api.doc.result.sync.ApiDocSingleSyncOrderResultDto;
import cn.com.duiba.quanyi.center.api.enums.api.ApiOrderStatusEnum;
import cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum;
import cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiSupplyUtils {
    private static final Logger log = LoggerFactory.getLogger(ApiSupplyUtils.class);

    private ApiSupplyUtils() {
    }

    public static ApiDocDto<ApiDocOrderCreateDto> convertCreate(ApiOrderResult result) {
        return ApiSupplyUtils.convert(result, () -> {
            if (ApiSupplyUtils.isPkg(result)) {
                ApiDocPkgOrderCreateDto createDto = (ApiDocPkgOrderCreateDto)BeanUtils.copy((Object)result, ApiDocPkgOrderCreateDto.class);
                createDto.setGoodsPkgFlag(true);
                return createDto;
            }
            ApiDocSingleOrderCreateDto createDto = (ApiDocSingleOrderCreateDto)BeanUtils.copy((Object)result, ApiDocSingleOrderCreateDto.class);
            createDto.setOrderNum(result.getMainOrderNum());
            return createDto;
        });
    }

    public static ApiDocDto<ApiDocOrderResultDto> convertAsyncResult(ApiOrderResult result) {
        return ApiSupplyUtils.convertResult(result, ApiDocPkgSubAsyncOrderResultDto.class, ApiDocSingleAsyncOrderResultDto.class);
    }

    public static ApiDocDto<ApiDocOrderResultDto> convertSyncResult(ApiOrderResult result) {
        return ApiSupplyUtils.convertResult(result, ApiDocPkgSubSyncOrderResultDto.class, ApiDocSingleSyncOrderResultDto.class);
    }

    private static <P extends ApiDocPkgSubSyncOrderResultDto, S extends ApiDocSingleSyncOrderResultDto> ApiDocDto<ApiDocOrderResultDto> convertResult(ApiOrderResult result, Class<P> pkgSubClass, Class<S> singleClass) {
        return ApiSupplyUtils.convert(result, () -> {
            if (ApiSupplyUtils.isPkg(result)) {
                ApiDocPkgOrderResultDto resultDto = new ApiDocPkgOrderResultDto();
                BeanUtils.copy((Object)result, resultDto);
                resultDto.setGoodsPkgFlag(true);
                resultDto.setSubOrderDataList(ApiSupplyUtils.convertPkgSub(result.getSubOrderDataList(), pkgSubClass));
                return resultDto;
            }
            return ApiSupplyUtils.convertSingle(result, singleClass);
        });
    }

    private static <T extends ApiDocSingleSyncOrderResultDto> T convertSingle(ApiOrderResult result, Class<T> clazz) {
        List<ApiQuerySubOrderResult> subOrderDataList = result.getSubOrderDataList();
        if (CollectionUtils.isEmpty(subOrderDataList)) {
            ApiDocSingleSyncOrderResultDto dto = (ApiDocSingleSyncOrderResultDto)BeanUtils.copy((Object)result, clazz);
            dto.setOrderNum(result.getMainOrderNum());
            return (T)dto;
        }
        if (subOrderDataList.size() > 1) {
            log.error("[ApiSupply], not pkg, but subOrderDataList limit 1, result={}", (Object)result);
        }
        ApiQuerySubOrderResult subOrderResult = subOrderDataList.get(0);
        ApiDocSingleSyncOrderResultDto dto = (ApiDocSingleSyncOrderResultDto)BeanUtils.copy((Object)subOrderResult, clazz);
        dto.setOrderStatus(ApiSupplyUtils.convertGoodsStatus(subOrderResult).getStatus());
        dto.setOrderNum(result.getMainOrderNum());
        dto.setRemark(result.getRemark());
        dto.setThirdOrderId(result.getThirdOrderId());
        return (T)dto;
    }

    private static <T extends ApiDocPkgSubSyncOrderResultDto> List<T> convertPkgSub(List<ApiQuerySubOrderResult> subOrderDataList, Class<T> clazz) {
        if (CollectionUtils.isEmpty(subOrderDataList)) {
            return Collections.emptyList();
        }
        return subOrderDataList.stream().map(result -> {
            ApiDocPkgSubSyncOrderResultDto sub = (ApiDocPkgSubSyncOrderResultDto)BeanUtils.copy((Object)result, (Class)clazz);
            sub.setSubOrderStatus(ApiSupplyUtils.convertGoodsStatus(result).getStatus());
            return sub;
        }).collect(Collectors.toList());
    }

    private static boolean isPkg(ApiOrderResult result) {
        return ApiSpecTypeEnum.PKG.getType().equals(result.getSpecType()) || ApiSpecTypeEnum.QUANTITY.getType().equals(result.getSpecType());
    }

    private static <T extends Serializable> ApiDocDto<T> convert(ApiOrderResult result, Supplier<T> func) {
        if (result == null) {
            return null;
        }
        ApiDocDto<T> dto = new ApiDocDto<T>();
        if (!result.isSuccess()) {
            return dto.buildError(result.getErrCode(), result.getErrMsg());
        }
        return dto.buildSuccess(func);
    }

    private static ApiOrderStatusEnum convertGoodsStatus(ApiQuerySubOrderResult subOrderResult) {
        if (ApiSupplyUtils.isIssued(subOrderResult)) {
            return ApiOrderStatusEnum.ISSUED;
        }
        GoodsOrderStatusEnum goodsOrderStatusEnum = GoodsOrderStatusEnum.getByStatus(subOrderResult.getOrderStatus());
        if (goodsOrderStatusEnum == null) {
            return ApiOrderStatusEnum.PROCESS;
        }
        switch (goodsOrderStatusEnum) {
            case FAIL: {
                return ApiOrderStatusEnum.FAIL;
            }
            case SUCCESS: {
                return ApiOrderStatusEnum.RECEIVED;
            }
            case VERIFICATION: {
                return ApiOrderStatusEnum.VERIFICATION;
            }
            case EXPIRED: {
                return ApiOrderStatusEnum.EXPIRED;
            }
            case RECEIVED: {
                return ApiOrderStatusEnum.RED_PACK_RECEIVED;
            }
            case REFUND: {
                return ApiOrderStatusEnum.REFUND;
            }
            case INVALID: {
                return ApiOrderStatusEnum.INVALID;
            }
            case UNSHIPPED: {
                return ApiOrderStatusEnum.UNSHIPPED;
            }
            case SHIPPED: {
                return ApiOrderStatusEnum.SHIPPED;
            }
            case COMPLETED: {
                return ApiOrderStatusEnum.COMPLETED;
            }
            case CANCELED: {
                return ApiOrderStatusEnum.CANCELED;
            }
            case RETURNED: {
                return ApiOrderStatusEnum.RETURNED;
            }
            case CLOSE: {
                return ApiOrderStatusEnum.CLOSE;
            }
        }
        return ApiOrderStatusEnum.PROCESS;
    }

    private static boolean isIssued(ApiQuerySubOrderResult subOrderResult) {
        if (GoodsOrderStatusEnum.isShortUrlStatus(subOrderResult.getOrderStatus())) {
            return true;
        }
        return SpuTypeEnum.KA_MI.getType().equals(subOrderResult.getSpuType()) && GoodsOrderStatusEnum.SUCCESS.getStatus().equals(subOrderResult.getOrderStatus());
    }
}

