package cn.com.duiba.quanyi.center.api.dto.api;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/12/20 15:33
 */
@Data
public class ApiBaseResult implements Serializable {
    
    private static final long serialVersionUID = -1721223473760586240L;

    /**
     * 是否请求成功，不代表订单已成功
     */
    private boolean success;

    /**
     * 错误码
     */
    private String errCode;

    /**
     * 错误描述
     */
    private String errMsg;

    public <T extends ApiBaseResult> T buildError(String errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
        return (T)this;
    }
}
