package cn.com.duiba.quanyi.center.api.enums.coupon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Map;
import java.util.stream.Collectors;

/**
 * 立减类型
 * reduce:满立减(满5元减3元)
 * 定额立减(定额满减): single
 * 折扣立减: discount
 * 随机金额立减(随机满减): random
 * 智能立减: intelligentAlgorithm
 * 多阶梯立减: multiStagedDiscount
 *
 * @see <a>https://opendocs.alipay.com/apis/07yvpj</>
 */
@Getter
@AllArgsConstructor
public enum AlipayDiscountTypeEnum {
    REDUCE("reduce", "满立减"),
    SINGLE("single", "定额立减(定额满减)"),
    DISCOUNT("discount", "折扣立减"),
    RANDOM("random", "随机金额立减(随机满减)"),
    INTELLIGENT_ALGORITHM("intelligentAlgorithm", "智能立减"),
    MULTI_STAGED_DISCOUNT("multiStagedDiscount", "多阶梯立减"),
    ;

    private final String type;

    private final String desc;

    public static Integer getByType(String discountType) {
        if (REDUCE.getType().equals(discountType) || SINGLE.getType().equals(discountType)) {
            return AmountTypeEnum.FIXED.getType();
        }
        if (DISCOUNT.getType().equals(discountType) || RANDOM.getType().equals(discountType) || INTELLIGENT_ALGORITHM.getType().equals(discountType) || MULTI_STAGED_DISCOUNT.getType().equals(discountType)) {
            return AmountTypeEnum.UNFIXED.getType();
        }
        return null;
    }

    /**
     * 获取不固定金额，最小和最大金额
     * @param discountType 优惠类型
     * @param discountValue 优惠值
     * @return 左边：最小金额，右边：最大金额
     */
    public static Pair<Long, Long> getMinAmountAndMaxAmount(String discountType, String discountValue) {
        if (StringUtils.isEmpty(discountType) || StringUtils.isEmpty(discountValue)) {
            return null;
        }
        if (RANDOM.getType().equals(discountType)){
            // 解析 JSON 字符串
            JSONObject jsonObject = JSON.parseObject(discountValue);
            JSONArray rangeInfoList = jsonObject.getJSONArray("rangeInfoList");
            if (rangeInfoList != null && !rangeInfoList.isEmpty()) {
                JSONObject rangeInfo = rangeInfoList.getJSONObject(0);
                Long minAmount = Long.valueOf(rangeInfo.getString("minAmount"));
                Long maxAmount = Long.valueOf(rangeInfo.getString("maxAmount"));
                return Pair.of(minAmount, maxAmount);
            }
        }

        if (INTELLIGENT_ALGORITHM.getType().equals(discountType)){
            // 解析 JSON 字符串
            JSONObject jsonObject = JSON.parseObject(discountValue);
            if (jsonObject != null) {
                Long minAmount = Long.valueOf(jsonObject.getString("minAmount"));
                Long maxAmount = Long.valueOf(jsonObject.getString("maxAmount"));
                return Pair.of(minAmount, maxAmount);
            }
        }

        return null;
    }
}
