package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 美团支付劵表
 * @author mybatis generator 
 * @date 2024-09-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MeiTuanCouponSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17263071549755996L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 商户ID
     */
    private String mchId;

    /**
     * 批次号
     */
    private Long batchId;

    /**
     * 券批次名称
     */
    private String batchName;

    /**
     * 券批次状态
1-编辑中
2-待审核
3-待提交
4-审核驳回
5-进行中
6-已结束
7-已停用
8-创建失败
     */
    private Integer batchStatus;

    /**
     * 券类型
1-立减券
3-满减券
4-折扣券
7-口价券
     */
    private Integer couponType;

    /**
     * 门槛金额
立减为null
满减券、折扣券不为null
     */
    private Long quotaValue;

    /**
     * 减金额
立减券返回优惠金额
折扣券返回最大抵扣金额
     */
    private Long reduceValue;

    /**
     * 折扣券不为null
满减券、立减券为null
     */
    private Long discountValue;

    /**
     * 券展示标题
     */
    private String titleShow;

    /**
     * 券使用限制说明（展示说明）
     */
    private String restrictShow;

    /**
     * 批次有效期结束时间
     */
    private Date assignEndTime;

    /**
     * 批次有效期开始时间
     */
    private Date validBeginTime;

    /**
     * 券有效期开始时间
当券有效类型是1、3时，有值
当券有效期类型是2倒计时，为null
     */
    private Date beginTime;

    /**
     * 券有效期结束时间
当券有效类型是1、3时，有值
当券有效期类型是2倒计时，为null
     */
    private Date endTime;

    /**
     * 券有效期类型
1.只有结束时间 2.倒计时时间 3.开始和结束时间
     */
    private Integer usableTimeType;

    /**
     * 倒计时天数
当券有效期类型是2倒计时，倒计时天数等于券有效期天数
     */
    private Integer countDownDays;

    /**
     * 发券形式
1-系统发放
2-兑换码
     */
    private Integer bindType;

    /**
     * 同一用户批次总领取限制
0不限制 
大于0即每个用户可限领张数
     */
    private Integer userReceiveLimit;

    /**
     * 同一用户日领取限制
0不限制 
大于0即每个用户可限领张数
     */
    private Integer daySendLimit;

    /**
     * 同一用户周领取限制
0不限制 
大于0即每个用户可限领张数
     */
    private Integer weekSendLimit;

    /**
     * 同一用户月领取限制
0不限制 
大于0即每个用户可限领张数
     */
    private Integer monthSendLimit;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购商品主键, tb_purchase_goods.id
     */
    private Long demandGoodsId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 是否启用：1启用 0未启用
     */
    private Integer enableStatus;

    /**
     * 是否自动创建 0-否 1-是
     */
    private Integer autoCreate;

    /**
     * 是否需要告警，0-不需要，1-需要
     */
    private Integer needWarn;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人操作Id,ssoname
     */
    private String createOperatorName;
}