/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.ccb;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum ChannelEnum {
    WX("wx", "\u5fae\u4fe1"),
    ALI("ali", "\u652f\u4ed8\u5b9d");

    private final String channelType;
    private final String desc;
    private static final Map<String, ChannelEnum> ENUM_MAP;

    public static ChannelEnum getByType(String channelType) {
        if (StringUtils.isBlank((CharSequence)channelType)) {
            return null;
        }
        return ENUM_MAP.get(channelType);
    }

    public String getChannelType() {
        return this.channelType;
    }

    public String getDesc() {
        return this.desc;
    }

    private ChannelEnum(String channelType, String desc) {
        this.channelType = channelType;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ChannelEnum.values()).collect(Collectors.toMap(ChannelEnum::getChannelType, Function.identity(), (v1, v2) -> v2)));
    }
}

