package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.MeiTuanCouponStockDto;
import cn.com.duiba.quanyi.center.api.param.coupon.MeiTuanCouponStockSearchParam;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 美团支付劵库存表
 * @author kjj mybatis generator 
 * @date 2024-09-12
 */
@AdvancedFeignClient
public interface RemoteMeiTuanCouponStockService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 美团支付劵库存集合
     */
    List<MeiTuanCouponStockDto> selectPage(MeiTuanCouponStockSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MeiTuanCouponStockSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 美团支付劵库存
     */
    MeiTuanCouponStockDto selectById(Long id);

    /**
     * 新增
     * @param dto 美团支付劵库存
     * @return 执行结果
     */
    int insert(MeiTuanCouponStockDto dto);

    /**
     * 更新
     * @param dto 美团支付劵库存
     * @return 影响行数
     */
    int update(MeiTuanCouponStockDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
    
    /**
     * 根据美团支付券主键批量查询
     *
     * @param couponIds 美团支付券ID集合
     * @return key：立减金ID，value：美团支付券库存
     */
    Map<Long, MeiTuanCouponStockDto> selectByMeiTuanCouponIdList(List<Long> couponIds);
}