package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;


@Getter
@AllArgsConstructor
public enum VerifyNotifySceneTypeEnum {
    STANDARD(1, "标准对接"),
    DEBIT_CUSTOM(2, "银数定制对接"),
    PSBC_CUSTOM(3, "邮储定制对接"),
    ZG_BANK_CUSTOM(4, "中国银行定制对接")
    ;

    private final Integer type;

    private final String desc;

    private static final Map<Integer, VerifyNotifySceneTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(VerifyNotifySceneTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static VerifyNotifySceneTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
