package cn.com.duiba.quanyi.center.api.remoteservice.demand;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandDto;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPageQueryParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 需求表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteDemandService {
    /**
     * 根据主键查询
     *
     * @param list 主键
     * @return 需求
     */
    Map<Long, DemandDto> selectByIdList(Set<Long> list);

    /**
     * 根据需求id集合查询需求名称
     * @param list 需求id集合
     * @return 需求id: 需求名称
     */
    Map<Long, String> selectDemandNameMap(Set<Long> list);

    /**
     * 分页查询
     *
     * @param param 请求参数
     * @return 需求列表
     */
    List<DemandDto> selectPage(DemandPageQueryParam param);

    /**
     * 查询(不分页)
     *
     * @param demandPageQueryParam 参数
     * @return 结果
     */
    List<DemandDto> selectNoPage(DemandPageQueryParam demandPageQueryParam);

    /**
     * count
     *
     * @param param 请求参数
     * @return 数量
     */
    Integer count(DemandPageQueryParam param);

    /**
     * 新增
     *
     * @param demandDto
     * @return
     */
    Long insert(DemandDto demandDto);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    DemandDto findById(Long id);

    /**
     * 更新
     *
     * @param demandDto
     * @return
     */
    int update(DemandDto demandDto);

    /**
     * 根据需求id删除对应的需求记录
     * @param id 需求主键id字段
     */
    void delete(Long id);

    /**
     * 根据创建人id批量修改创建人信息为当前登录用户
     * @param param 封装的参数信息
     * @return 返回受影响的行数
     */
    Integer batchUpdateOperator(DemandPageQueryParam param);
}